<?xml version="1.0"?>
<xsl:stylesheet xmlns:oai="http://www.openarchives.org/OAI/2.0/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" version="1.0">
<xsl:output method="text" indent="no" omit-xml-declaration="yes" /> 

<xsl:template match="/">@electronic{arXiv:<xsl:value-of select="substring(//oai:header/oai:identifier, 15)" />,
	Author = {<xsl:apply-templates select="//dc:creator" />},
	Eprint = {\href{<xsl:value-of select="//dc:identifier" />}{arXiv:<xsl:value-of select="substring(//oai:header/oai:identifier, 15)" />}},
<xsl:call-template name="bibtex-month"><xsl:with-param name="date" select="//dc:date" /></xsl:call-template>	Title = {<xsl:call-template name="escape-bibtex"><xsl:with-param name="text" select="//dc:title" /></xsl:call-template>},
	Year = {<xsl:value-of select="substring(//dc:date, 1, 4)" />}
}
</xsl:template>

<xsl:template match="dc:creator"><xsl:if test="not(position()=1)"> and </xsl:if><xsl:value-of select="." /></xsl:template>

<xsl:template name="bibtex-month"><xsl:param name="date" /><xsl:if test="substring($date, 6, 2)='01'">	Month = {January},
</xsl:if><xsl:if test="substring($date, 6, 2)='02'">	Month = {February},
</xsl:if><xsl:if test="substring($date, 6, 2)='03'">	Month = {March},
</xsl:if><xsl:if test="substring($date, 6, 2)='04'">	Month = {April},
</xsl:if><xsl:if test="substring($date, 6, 2)='05'">	Month = {May},
</xsl:if><xsl:if test="substring($date, 6, 2)='06'">	Month = {June},
</xsl:if><xsl:if test="substring($date, 6, 2)='07'">	Month = {July},
</xsl:if><xsl:if test="substring($date, 6, 2)='08'">	Month = {August},
</xsl:if><xsl:if test="substring($date, 6, 2)='09'">	Month = {September},
</xsl:if><xsl:if test="substring($date, 6, 2)='10'">	Month = {October},
</xsl:if><xsl:if test="substring($date, 6, 2)='11'">	Month = {November},
</xsl:if><xsl:if test="substring($date, 6, 2)='12'">	Month = {December},
</xsl:if></xsl:template>

<xsl:template name="escape-bibtex"><xsl:param name="text" /><xsl:call-template name="replace-text">
	<xsl:with-param name="text"><xsl:call-template name="replace-text">
		<xsl:with-param name="text"><xsl:call-template name="replace-text">
			<xsl:with-param name="text" select="$text" />
			<xsl:with-param name="replace">\</xsl:with-param>
			<xsl:with-param name="by">\\</xsl:with-param>
		</xsl:call-template></xsl:with-param>
		<xsl:with-param name="replace">}</xsl:with-param>
		<xsl:with-param name="by">\}</xsl:with-param>
	</xsl:call-template></xsl:with-param>
	<xsl:with-param name="replace">{</xsl:with-param>
	<xsl:with-param name="by">\{</xsl:with-param>
</xsl:call-template></xsl:template>

<!-- template that does a search & replace -->
<xsl:template name="replace-text">
   <xsl:param name="text"/>
   <xsl:param name="replace" />
   <xsl:param name="by"  />

   <xsl:choose>
   <xsl:when test="contains($text, $replace)">
      <xsl:value-of select="substring-before($text, $replace)"/>
      <xsl:value-of select="$by" disable-output-escaping="yes"/>
      <xsl:call-template name="replace-text">
         <xsl:with-param name="text" select="substring-after($text, $replace)"/>
         <xsl:with-param name="replace" select="$replace" />
         <xsl:with-param name="by" select="$by" />
      </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="$text"/>
   </xsl:otherwise>
   </xsl:choose>

</xsl:template>

</xsl:stylesheet>
